var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-9D3DCC87-31C7-4291-B80C-8A4FAB8F0F29\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>About the tutorial assets</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-9D3DCC87-31C7-4291-B80C-8A4FAB8F0F29\"></a><div class=\"head\">\n            <h1>About the tutorial assets</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48E5\"></a>Throughout this tutorial, you use four variations of the character’s polygon mesh\n            clothing: a low resolution, medium resolution, high resolution, and reference character\n            version. To view the tutorial assets, open <span class=\"code\">Character_Multiple_Resolution.mb</span> in Maya. The following sections describe each asset. \n         </p>\n         <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E40\"></a>Use of any data from <em class=\"mild\">The Spine</em> in this tutorial is courtesy of the National Film Board of Canada. \n         </p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-48E4\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D6E762EC-5DFF-4CBA-97DE-E5636CDF784E-low.png\"><p class=\"figure-title\">From left to right, the assets are, the medium resolution shirt and pants, low resolution\n               shirt and pants, high resolution shirt and pants, and reference character.\n            </p>\n         </div>\n         <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73B3\"></a> \n            <h2><a name=\"GUID-E1A141CC-4CE1-4AC3-AD23-486ABA673DAB\"></a>Low resolution polygon meshes\n            </h2> \n            <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73B2\"></a>The low resolution shirt (Shirt_LowRes) and pants (Pants_LowRes) objects are the low\n               resolution meshes that you convert to nCloth and simulate. Most lessons in this tutorial\n               focus on optimizing the simulation of these low resolution objects. The low resolution\n               shirt and pants are used as the wrap influence objects for the wrap deformer. The\n               Shirt_LowRes object consists of 180 faces and the Pants_LowRes object consists of\n               244 faces. \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73B1\"></a> \n            <h2><a name=\"GUID-8091352E-E6FF-441F-9E66-F41B94AE9074\"></a>High resolution polygon meshes\n            </h2> \n            <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73B0\"></a>The high resolution shirt (Shirt_HighRes) and pants (Pants_HighRes) objects are the\n               high resolution meshes used as the deform objects for the wrap deformer. At various\n               stages of this tutorial, you show these meshes in the scene view to observe how the\n               wrap deformer meshes behave when influenced by the low resolution nCloth shirt and\n               pants. The Shirt_HighRes object consists of 6510 faces and the Pants_HighRes object\n               consists of 5712 faces. \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62F0\"></a> \n            <h2><a name=\"GUID-AAC8E957-12A5-4481-B72A-E417A850006C\"></a>Medium resolution polygon meshes\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62EF\"></a>In the final lesson of the tutorial, you apply a custom nCloth attribute preset to\n               the medium shirt (Shirt_MedRes) and pants (Pants_MedRes) objects. The nCloth preset\n               is created from the attribute values used for the low resolution nCloth simulation.\n               Like the low resolution shirt and pants, the medium resolution objects are also used\n               as the wrap influence objects for the wrap deformer. \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73AF\"></a> \n            <h2><a name=\"GUID-1D7849FB-7C97-4648-A020-617881DD10A3\"></a>Reference Character\n            </h2> \n            <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-73AE\"></a>The reference character (Reference_Character) is a high resolution version of the\n               character and clothing (shirt and pants), which is animated using a cached simulation.\n               It represents the final high resolution mesh that you want to emulate when simulating\n               the low resolution meshes with the wrap deformer. At various stages of the tutorial,\n               you can display the reference character object in the scene view to compare with your\n               current low resolution nCloth simulation. \n            </p> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62EE\"></a> In the tutorial scene files, the reference character appears hidden. To display the\n               object, turn on Visible in the <span class=\"MenuCascade\" id=\"GUID-2DAFB31B-3BA1-40DE-958E-77BF38EC1DD3\">Display Layer</span> editor. \n            </p> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62ED\"></a>For information about the<span class=\"MenuCascade\" id=\"GUID-C83A66A8-51A7-4E74-8262-8AF28E0E8C88\"> Display Layer</span> editor, see <em class=\"mild\">Display Layer editor</em> in the <em class=\"mild\">Basics</em> guide. \n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D74\"></a> \n            <h2><a name=\"GUID-AA890F5A-EDD5-44C5-AA49-A4E92FAF8F54\"></a>General modeling considerations\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D73\"></a>In this tutorial, the terms low, medium, and high resolution are used to distinguish\n               each mesh. The terminology is not intended to define the composition of a low, medium,\n               or high resolution mesh, but rather to describe the mesh’s general characteristics.\n               When modeling geometry for nCloth, consider the following guidelines: \n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D72\"></a><ul>\n               <li>High resolution meshes typically look better in a scene than low or medium resolution\n                  meshes; however, they take considerably more time to simulate. It is important to\n                  establish where in the scene the character wearing the nCloth is to appear. The character’s\n                  placement helps determine the level of detail for its clothing mesh. \n                  <p><a name=\"WS73099CC142F48755-789C4B1E11D24BE26D7-5891\"></a>For example, if the nCloth is used for a character in the foreground of your scene\n                     you will want to use a high or medium resolution mesh. If the character is a stand-in\n                     or in the background of the scene, lower resolution meshes may be sufficient. \n                  </p> \n               </li>\n               <li>This tutorial assumes that no original low polygonal meshes were created, as all models\n                  are derived from the high-resolution meshes. The low and medium resolution meshes\n                  have been modeled based on the original high resolution mesh by superimposing the\n                  lower resolution meshes on top of the high resolution mesh. Modeling the lower resolution\n                  mesh on top of the original high resolution mesh lets you use the high resolution\n                  mesh to quickly identify problem areas in your simulation, such as the crotch and\n                  knees in the nCloth pants. \n               </li>\n               <li>You can use<span class=\"MenuCascade\" id=\"GUID-3076256E-6B19-468A-BC1E-E32EEDFC9BA7\"> Smooth Polygon Preview</span> mode to see what your low resolution mesh looks like with a higher polygon count.\n                  Be aware that when the mesh is converted to nCloth, it uses the base mesh and not\n                  the preview subdivided mesh. \n               </li>\n               <li>When modeling your low resolution meshes, try to superimpose them as closely as possible\n                  to the high resolution mesh. Doing this minimizes offsets between the meshes during\n                  the simulation, which can cause interpenetrations between the character\'s body and\n                  the high resolution mesh. These interpenetrations may not appear in the static frames\n                  (initial set up) of your simulation, but may appear in frames in which the character\n                  is animated. Be aware that interpenetrations are easier to resolve in the initial\n                  frames of your simulation. \n               </li>\n               <li>It is a best practice to model your mesh using equal sized quads, as this directly\n                  impacts how your nCloth behaves in the simulation. nCloth created from input meshes\n                  with similar sized polygons tend to produce more accurate collisions than nCloth meshes\n                  with polygons of varied sizes. Typically, meshes created from uniform quads provide\n                  better results in other character creation tasks, such as UV layout, skinning, and\n                  deformation. For more information, see <em class=\"mild\">Optimizing geometry for nCloth conversion</em> in the <em class=\"mild\">nDynamics</em> guide. \n               </li>\n            </ul> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";